/**
* \file: AlsaAudioSource.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: I. Hayashi / ADITJ/SW / ihayashi@jp.adit-jv.com
*
* \copyright (c) 2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include "AlsaAudioSource.h"
#include "AlsaAudioSourceImpl.h"

namespace adit { namespace aauto {

AlsaAudioSource::AlsaAudioSource(uint8_t inSessionId, MessageRouter* inMessageRouter,
        int inCodec) :
                AditAudioSource(inSessionId, inMessageRouter, inCodec)
{
    impl = new AlsaAudioSourceImpl(this);
}

AlsaAudioSource::~AlsaAudioSource()
{
    /* This impl pointer is deleted at shared_ptr in callbak impl on GalReceiver */
}

bool AlsaAudioSource::init()
{
    return impl->init();
}
void AlsaAudioSource::shutdown()
{
    impl->shutdown();
}
void AlsaAudioSource::setConfigItem(string inKey, string inValue)
{
    return impl->setConfigItem(inKey, inValue);
}

void AlsaAudioSource::registerCallbacks(IAditAudioSourceCallbacks* inCallbacks)
{
    return impl->registerCallbacks(inCallbacks);
}

} } // namespace adit { namespace aauto {
